/************************************************************************
 *
 * \file: EventDispatcher.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - demo
 *
 * \author: Sonali Pujari / SonaliSajan.Pujari@in.bosch.com
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef DEMO_PROTOTYPE_AAUTO_DEMO_SRC_UTILS_EVENTDISPATCHER_H_
#define DEMO_PROTOTYPE_AAUTO_DEMO_SRC_UTILS_EVENTDISPATCHER_H_

#include <pthread_adit.h>
#include <mutex>
#include <memory>
#include <cstring>
#include <deque>
#include <semaphore.h>

namespace adit { namespace aauto {

enum class DevEventType : int32_t
{
    NONE                = 0,
    ByeByeRequest       = 1,
    FirstFrameRendered  = 2,
    OTHER               = 3
};

class DevEventItem
{
public:
      DevEventItem( DevEventType inEvent,const std::string inSerial)
      :mEvent(inEvent), mSerial(inSerial) {}
      virtual ~DevEventItem() { }

      DevEventType getEventType() { return mEvent; }
      std::string getSerial() { return mSerial;}

private:
      DevEventType mEvent;
      std::string mSerial;
};

class EventDispatcher
{
public:
      EventDispatcher();
      virtual ~EventDispatcher();

      bool startEventDispatcher();
      void stopEventDispatcher();

      void queueEvent(const std::shared_ptr<DevEventItem>& work);

protected:
      // to be implemented by user
      virtual void onByeByeRequest(std::string serial) = 0;

private:
      void handleEvent(std::shared_ptr<DevEventItem> inEventItem);
      static void* EventDispatcherThread(void* context);
      pthread_t mEventDispatcherThreadId;
      bool mRunning;
      sem_t mEventAvailable;
      bool mSemCreated;
      std::shared_ptr<DevEventItem> dequeueEvent();
      std::deque<std::shared_ptr<DevEventItem> > mEventQueue;
      std::mutex mEventQueueMutex;
};

} } /* namespace adit { namespace aauto { */




#endif /* DEMO_PROTOTYPE_AAUTO_DEMO_SRC_UTILS_EVENTDISPATCHER_H_ */
